/*******************************************************************
*
*  DESCRIPTION: Atomic Model RadarController
*
*  AUTHOR: Dieynaba Alpha Tall
*
*  EMAIL: alphadieynaba@yahoo.fr
*
*
*  DATE: 06/08/2009
*******************************************************************/

/** include files **/
#include <math.h>            // fabs( ... )
#include "SensorController.h"  // base header
#include "message.h"       // InternalMessage ....
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )
#include "commonH.h"


/*******************************************************************
* Function Name: RadarController
* Description: constructor
********************************************************************/
SensorController::SensorController( const std::string &name ) : Atomic( name )
, sctrl_mctrl_in( addOutputPort( "sctrl_mctrl_in" ) )
, sctrl_start_in( addInputPort( "sctrl_start_in" ) )
, sctrl_light_in( addInputPort( "sctrl_light_in" ) )
, sctrl_mctrl_out( addOutputPort( "sctrl_mctrl_out" ) )
, sctrl_start_out( addOutputPort( "sctrl_start_out" ) )
, scTxTime (00,00,00,10)
, scRxPrepTime (00,00,00,10)

{
	std::string timemessage( MainSimulator::Instance().getParameter( description(), "scTxTime" ) ) ;
	std::string timemessage2( MainSimulator::Instance().getParameter( description(), "scRxPrepTime" ) ) ;

//test
	if (timemessage !="") scTxTime = timemessage;
	if (timemessage2 !="") scRxPrepTime = timemessage2;

	//MainSimulator::Instance().Spin_Motor_Clockwise(30);

	cout<<"scTxTime="<<scTxTime<<"\n";
	cout<<"scRxPrepTime="<<scRxPrepTime<<"\n";

}

/*******************************************************************
* Function Name: RadarController::initFunction()
* Description: Initialization Function
********************************************************************/
Model &SensorController::initFunction()
{
	state = IDLE;		// detecting
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: RadarController::externalFunction()
* Description: External Function RadarController
********************************************************************/
Model &SensorController::externalFunction( const ExternalMessage &msg )
{	
	cout << "--> In SCTRL ExtFunc() / state= " << state;
	
	if (msg.port() == sctrl_start_in){

		cout << "/ port= sctrl_start_in / value= " << static_cast <int> (msg.value());
		
		if(state == IDLE && msg.value()== START_PROC){
			state = PREP_RX;
			holdIn( Atomic::active, scRxPrepTime );
		}
		
		else if (msg.value()== STOP_PROC) {
			state = PREP_STOP;
			holdIn( Atomic::active, ZERO_TIME );
		}
	}
	else if (msg.port() == sctrl_light_in){
		
		cout << "/ port= sctrl_light_in / value= " << static_cast <int> (msg.value());
		
		if(state == WAIT_DATA) {
			sensor_input = static_cast<int>(msg.value());
			
			if(sensor_input == ALL_DARK) {
				state = PREP_STOP;
				holdIn( Atomic::active, ZERO_TIME );
				
			} else {
				state = TX_DATA;
				holdIn( Atomic::active, scTxTime );
			}
		}
	}
	
	cout << "/ new state= " << state << "\n";
	
	return *this;
}

/*******************************************************************
* Function Name: RadarController::internalFunction()
* Description: Internal Function RadarController
********************************************************************/
Model &SensorController::internalFunction( const InternalMessage & )
{
	cout << "<----- In SCTRL IntFunc() / state= " << state;
	
	switch (state){
		case PREP_STOP:
			state = IDLE;
			passivate();
			break;
			
		case PREP_RX:
		case TX_DATA:
			state = WAIT_DATA;
			passivate();
			break;
	}
	
	cout << "/ new state= " << state << "\n";
	
	return *this;
}

/*******************************************************************
* Function Name: RadarController::outputFunction()
* Description: Output function RadarController - writes info about time and events
********************************************************************/
Model &SensorController::outputFunction( const InternalMessage &msg )
{
	cout << "<----- In SCTRL OutFunc() / state= " << state;
	
	switch (state){
	
		case PREP_STOP:
			sendOutput( msg.time(), sctrl_start_out, STOP_PROC) ; //Stop Light Sensor
			sendOutput( msg.time(), sctrl_mctrl_out, STOP_PROC) ; //Stop Movement Ctrl
			
			cout << "/ sent " << STOP_PROC << " to sctrl_X_out\n";
			break;
			
		case PREP_RX:
			sendOutput( msg.time(), sctrl_start_out, START_PROC) ; //Start Light Sensor
			
			cout << "/ sent " << START_PROC << " to sctrl_start_out\n";
			break;
		
		case TX_DATA: {
			int output_val;
			
			if(sensor_input == DARK) output_val = ON_TRACK;
			else if(sensor_input == BRIGHT) output_val = OFF_TRACK;
			
			sendOutput( msg.time(), sctrl_mctrl_out, output_val) ; //Send feedback to Movement Ctrl
			cout << "/ sent " << output_val << " to sctrl_mctrl_out\n";
			break;
		}
	};
	return *this ;
}

SensorController::~SensorController()
{
	//MainSimulator::Instance().Spin_Motor_Stop();
}
